#ifndef __CPolygon__
#define __CPolygon__

#include "../Collections/TCountedPointerArray.hpp"
#include "CPoint.hpp"

//	===========================================================================

using Exponent::Collections::TCountedPointerArray;
using Exponent::MathTools::CPoint;

//	===========================================================================

namespace Exponent
{
	namespace MathTools
	{
		/**
		 * @class CPolygon CPolygon.hpp
		 * @brief Representation of a polygon
		 *
		 * @date 19/03/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CPolygon.hpp,v 1.5 2007/02/08 21:06:44 paul Exp $
		 */
		class CPolygon : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param numberOfPoints The total number of points in the polygon
			 */
			CPolygon(const long numberOfPoints);

			/**
			 * Copy construction
			 * @param polygon The polygon
			 */
			CPolygon(const CPolygon &polygon);

			/**
			 * Default construction
			 */
			CPolygon();

			/**
			 * Destruction
			 */
			virtual ~CPolygon();

//	===========================================================================

			/**
			 * Assignment operator
			 * @param polygon The polygon to copy
			 * @retval CPolygon& A reference to this
			 */
			virtual CPolygon &operator = (const CPolygon &polygon);

			/**
			 * Equality operator
			 * @param polygon The polygon to compare to
			 * @retval bool True if polygons are equal, false otherwise
			 */
			virtual bool operator == (const CPolygon &polygon);

//	===========================================================================

			/**
			 * Set a point
			 * @param point The position
			 * @param index The index of this point
			 */
			void setPoint(const CPoint &point, const long index);

			/**
			 * Get a specific point
			 * @param index The index of the point required
			 * @retval CPoint* The point requested or NULL on error
			 */
			CPoint *getPoint(const long index);

			/**
			 * Get the point array
			 * @retval const TCountedPointerArray<CPoint>* The point array
			 */
			const TCountedPointerArray<CPoint> *getPointArray() const { return m_pointArray; }

			/**
			 * Get the point array
			 * @retval TCountedPointerArray<CPoint>* The point array
			 */
			TCountedPointerArray<CPoint> *getMutablePointArray() const { return m_pointArray; }

			/**
			 * Initialise the array
			 * @param numberOfPoints The number of points in the array
			 */
			void initialiseArray(const long numberOfPoints);

			/**
			 * Get the number of points
			 * @retval long The number of points in the polygon 
			 */
			long getNumberOfPoints() const;

			/**
			 * Offset the position of the rectangle
			 * @param point The position to offset by
			 */
			void offset(const CPoint &point);

//	===========================================================================

		protected:

//	===========================================================================

			TCountedPointerArray<CPoint> *m_pointArray;				/**< The array of points */
		};
	}
}
#endif	// End of CPolygon.hpp